/// @description Insert description here
// You can write your code in this editor
event_inherited();
depthAmount = -y;
if(instance_exists(oPlayer))
{
	if(oPlayer.x - x != 0) xScale = sign(oPlayer.x - x);
	if(point_distance(x, y, oPlayer.x, oPlayer.y) >= targetRange && collision_line(x, y, oPlayer.x, oPlayer.y, oCollision, false, true))
	{
		mp_potential_step(oPlayer.x, oPlayer.y, spd, false);
		//mp_potential_step_object(oPlayer.x, oPlayer.y, spd/2, oEnemy);
	}
	else
	{
		//Shoot projectile
		if(alarm[0] <= 0)
		{
			alarm[0] = fireRate;
			var _dir = point_direction(x,y,oPlayer.x,oPlayer.y);
			var bullet = instance_create(x + (lengthdir_x(sprite_width, _dir)), y + lengthdir_y(sprite_height, _dir)*image_yscale, projectile);
			bullet.parent = id;
			bullet.direction = _dir;
			bullet.vx = lengthdir_x(projectileSpeed, _dir);
			bullet.vy = lengthdir_y(projectileSpeed, _dir);
			bullet.image_angle = _dir;
			bullet.hp = room_speed*3;
		}
	}
}

if(x != xprevious || y != yprevious)
{
	sprite_index = runSprite;
}
else sprite_index = idleSprite;

if(hp <= 0)
{
	instance_destroy(collisionBox);
	var _inst = instance_create(x, y, oEnemyRagdoll);
	_inst.sprite_index = ragdollSprite;
	global.kills++;
	instance_destroy();
}
else
{
	if(!instance_exists(collisionBox))
	{
		collisionBox = instance_create(x, y, oEntityCollisionBox);
		collisionBox.parent = id;
		collisionBox.sprite_index = sprSkeletonCollisionBox;
		trace(current_time);
	}
}